plotlinewidth=4;
start=[3*10^(-4);guess_maximum; 0; 10];
up = [1;guess_maximum*1.05;+5; 200];
low = [0.000001;guess_maximum*0.95;0.0; 5];%d?mpfung, resonanzfrequenz,y-offset, peak-h?he
%,'Display','iter'
[val_low, index_low]=min(abs(result_frequency(:)-guess_maximum*0.7));
[val_up, index_up]=min(abs(result_frequency(:)-guess_maximum*1.4));
optionsforfit = fitoptions('Method', 'NonlinearLeastSquares','MaxIter',200,'TolFun',10^-10,'TolX',10^-10,'Upper',up,'Lower',low,'StartPoint',start);

typeoffit = fittype('d*(a*b)^2/((x-b)^2+(a*x)^2) + c', 'options', optionsforfit);


fitobject=fit(result_frequency(index_low:index_up)',double_result_amplitude(index_low:index_up)',typeoffit);
%fitobject=fit(transpose(data(dampnr,index_low:index_up,1)),transpose(data(dampnr,index_low:index_up,2)),typeoffit);
x=linspace(result_frequency(1),result_frequency(end),1000000);
coeff=coeffvalues(fitobject);
a=coeff(1);
b=coeff(2);
c=coeff(3);
d=coeff(4);

FWHM=2*sqrt(a^2*b^2 + 2*a^4*b^2)/(1 + a^2);
f_res=b;
Q=f_res/FWHM;
D=1/(2*Q);

figure;
hold on
if plot_counter==1
    title('Sideview')
elseif plot_counter==2
    title('Topview')
else
    title('Side+Top mean')
end
semilogx(x,d*(a*b).^2./((x-b).^2+(a*x).^2) + c,'LineWidth',1.8)
semilogx(result_frequency(index_low:index_up)',double_result_amplitude(index_low:index_up)','+','Linewidth',plotlinewidth,'color','r')
%errorbar(result_frequency,double_result_amplitude,err_bar)
hold off

dim = [.2 .74 .8 .15];
annotation('textbox',dim,'String',['f_0=', num2str(b,7),' kHz', newline , 'FWHM=', num2str(FWHM,3), ' kHz', newline,'Q=',num2str(Q,4), newline , 'D=', num2str(D,3)],'FitBoxToText','on');

xlabel('Frequency f in kHz')
ylabel('A^2 in  in units of the excitation amplitude')

if plot_counter==3;
    fit_result_amplitude=[a b c d];
    save('fit_result_amplitude.dat'  ,  'fit_result_amplitude', '-ascii' ,'-tabs');
end
